
const $CuriosAPI = Java.loadClass("top.theillusivec4.curios.api.CuriosApi")
const $CapabilitiesCurios = Java.loadClass("com.prunoideae.powerfuljs.capabilities.forge.mods.curios.CapabilitiesCurios")
const hasCurio = (entity, curio) => {
    return $CuriosAPI.getCuriosHelper().findEquippedCurio(curio, entity).isPresent()
}
let $SuperpositionHandler = Java.loadClass("com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler")
StartupEvents.registry("item", event => {
    event.create("kubejs:origin_eye")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
        )
        .maxStackSize(1)
        .rarity("common")
        .tag("curios:creation")
        .tag("l2hostility:no_seal")
        .displayName("原初之眼").texture("minecraft:item/ender_eye")
    event.create("kubejs:true_undead_eye")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item) && !$SuperpositionHandler.isTheCursedOne(entity)
                })
                .modifyAttribute("irons_spellbooks:holy_spell_power", "holy_eye", 0.4, "multiply_total")
                .modifyAttribute("l2damagetracker:damage_reduction", "holy_eye", -0.2, "multiply_total")
                .modifyAttribute("l2damagetracker:damage_absorption", "holy_eye", 2, "addition")
        )
        .maxStackSize(1)
        .rarity("epic")
        .glow(true)
        .tag("curios:creation")
        .tag("l2hostility:no_seal")
        .displayName("神圣不死之眼").texture("cataclysm:item/cursed_eye")

    event.create("kubejs:harmonious_magical_orb")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("irons_spellbooks:spell_power", "magical_orb", 0.1, "multiply_total")
                .modifyAttribute("irons_spellbooks:max_mana", "magical_orb", 0.25, "multiply_total")
                .modifyAttribute("irons_spellbooks:mana_regen", "magical_orb", 0.25, "multiply_total")
                .modifyAttribute("irons_spellbooks:cast_time_reduction", "magical_orb", 0.1, "multiply_total")
                .modifyAttribute("irons_spellbooks:cooldown_reduction", "magical_orb", 0.1, "multiply_total")
                .modifyAttribute("l2damagetracker:magic_damage", "magical_orb", 0.3, "multiply_total")
        )
        .maxStackSize(1)
        .rarity("epic")
        .glow(true)
        .tag("curios:creation")
        .displayName("调谐魔力法球")
        .textureJson({
      layer0: "irons_spellbooks:item/upgrade_orb_base",
      layer1: "irons_spellbooks:item/upgrade_orb_swirl"
    })

    event.create("kubejs:deep_cursed_soul")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("attributeslib:draw_speed", "cursed_soul", 1, "multiply_total")
                .modifyAttribute("attributeslib:arrow_velocity", "cursed_soul", 2, "multiply_total")
                .modifyAttribute("attributeslib:crit_chance", "cursed_soul", 0.2, "addition")
                .modifyAttribute("obscure_api:penetration", "cursed_soul", 0.3, "addition")
                .modifyAttribute("attributeslib:prot_shred", "cursed_soul", 0.2, "addition")
                .modifyAttribute("attributeslib:dodge_chance", "cursed_soul", 0.1, "addition")
        )
        .maxStackSize(1)
        .rarity("epic")
        .glow(true)
        .tag("curios:creation")
        .displayName("深刻诅咒之魂").texture("bosses_of_mass_destruction:item/ancient_anima")

    event.create("kubejs:frozen_cold_core")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("minecraft:generic.armor", "cold_core", 10, "addition")
                .modifyAttribute("minecraft:generic.attack_speed", "cold_core", 2, "addition")
                .modifyAttribute("minecraft:generic.attack_damage", "cold_core", 0.8, "multiply_total")
                .modifyAttribute("forge:entity_reach", "cold_core", 2, "addition")
        )
        .maxStackSize(1)
        .rarity("epic")
        .glow(true)
        .tag("curios:creation")
        .displayName("极霜寒冰之核").texture("mowziesmobs:item/icecrystal")

    event.create("kubejs:rude_rogue_blood")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("attributeslib:crit_chance", "rouge_blood", 0.2, "addition")
                .modifyAttribute("attributeslib:crit_damage", "rouge_blood", 0.2, "addition")
                .modifyAttribute("obscure_api:penetration", "rogue_blood", 0.4, "addition")
                .modifyAttribute("attributeslib:prot_shred", "rogue_blood", 0.4, "addition")
        )
        .maxStackSize(1)
        .rarity("epic")
        .glow(true)
        .tag("curios:creation")
        .displayName("原始暴戾之血").texture("twilightforest:item/fiery_blood")

    event.create("kubejs:wisdom_cryptic_piece")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("attributeslib:experience_gained", "cryptic_piece", 4, "multiply_total")
                .modifyAttribute("attributeslib:mining_speed", "cryptic_piece", 3, "multiply_total")
                .modifyAttribute("forge:block_reach", "cryptic_piece", 3, "addition")
        )
        .maxStackSize(1)
        .rarity("epic")
        .glow(true)
        .tag("curios:creation")
        .displayName("智慧知识碎片").texture("irons_spellbooks:item/ancient_knowledge_fragment")
        
    event.create("kubejs:burst_mech_eye")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("l2damagetracker:explosion_damage", "mech_eye", 1.5, "multiply_total")
        )
        .maxStackSize(1)
        .rarity("epic")
        .glow(true)
        .tag("curios:creation")
        .displayName("爆裂机械之眼").texture("cataclysm:item/mech_eye")
        
    event.create("advanced_creation:spell_disk", "irons_spells_js:spellbook")
        	.setMaxSpellSlots(15)
        	.addDefaultAttribute("irons_spellbooks:max_mana", "spell_disk", 400, "addition")
        	.addDefaultAttribute("irons_spellbooks:mana_regen", "spell_disk", 0.2, "multiply_total")
        	.addDefaultAttribute("irons_spellbooks:cooldown_reduction", "spell_disk", 0.3, "multiply_total")
        	.addDefaultAttribute("irons_spellbooks:cast_time_reduction", "spell_disk", 0.2, "multiply_total")
        	.tag("curios:spellbook")
        	.tag("l2hostility:no_seal")
        	.displayName("法术磁盘")
        

    event.create("kubejs:speed_charm")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("minecraft:generic.movement_speed", "speed_charm", 0.2, "multiply_base")
                .modifyAttribute("forge:entity_gravity", "speed_charm", -0.25, "multiply_total")
                .modifyAttribute("forge:swim_speed", "speed_charm", 0.25, "multiply_total")
        )
        .maxStackSize(1)
        .rarity("uncommon")
        .tag("curios:charm")
        .displayName("月华护符").texture("advanced_creation:item/speed_charm")

    event.create("kubejs:heavy_shot")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("minecraft:generic.movement_speed", "heavy_shot", -0.2, "multiply_base")
                .modifyAttribute("minecraft:generic.knockback_resistance", "heavy_shot", 1, "addition")
                .modifyAttribute("minecraft:generic.armor", "heavu_shot", 8, "addition")
        )
        .maxStackSize(1)
        .rarity("uncommon")
        .tag("curios:feet")
        .displayName("沉重铅球").texture("advanced_creation:item/heavy_shot")

    event.create("kubejs:ender_crytsal_ring")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .modifyAttribute("irons_spellbooks:ender_spell_power", "ender_crytsal_ring", 0.3, "multiply_total")
                .modifyAttribute("irons_spellbooks:cooldown_reduction", "ender_crytsal_ring", 0.15, "addition")
                .modifyAttribute("l2damagetracker:damage_reduction", "ender_crytsal_ring", 0.1, "multiply_total")
        )
        .maxStackSize(1)
        .rarity("rare")
        .tag("curios:ring")
        .displayName("末影结晶指环").texture("advanced_creation:item/ender_crytsal_ring")

    event.create("kubejs:bright_light")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
        )
        .maxStackSize(1)
        .rarity("uncommon")
        .tag("curios:head")
        .displayName("明视之灯").texture("advanced_creation:item/bright_light")


        
        event.create("kubejs:heart_light")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
                .onEquip((item, context) => {
                    let entity = context.entity()
                    entity.persistentData.putInt("heart_light_times",0)
                })
                .onUnequip((item, context) => {
                    let entity = context.entity()
                    entity.persistentData.remove("heart_light_times")
                })
                .modifyAttribute("attributeslib:healing_received", "heart_light", 0.75, "multiply_total")
        )
        .maxStackSize(1)
        .rarity("epic")
        .tag("curios:body")
        .displayName("心耀").texture("advanced_creation:item/heart_light")
        
            event.create("kubejs:mana_shield")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
        )
        .maxStackSize(1)
        .rarity("rare")
        .tag("curios:hands")
        .displayName("魔力之盾").texture("advanced_creation:item/mana_shield")

    event.create("kubejs:mana_damage_glove")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
        )
        .maxStackSize(1)
        .rarity("epic")
        .tag("curios:hands")
        .displayName("大法师至尊平A").texture("advanced_creation:item/mana_damage_glove")
        
    event.create("kubejs:beacon_necklace")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
        )
        .maxStackSize(1)
        .rarity("uncommon")
        .tag("curios:necklace")
        .displayName("信标核心挂坠").texture("advanced_creation:item/beacon_necklace")
        
    event.create("kubejs:conduit_charm")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
        )
        .maxStackSize(1)
        .rarity("uncommon")
        .tag("curios:charm")
        .displayName("潮涌核心护符").texture("advanced_creation:item/conduit_charm")
        
    event.create("kubejs:inspiration_crown")
        .attachCapability(
            $CapabilitiesCurios.CURIOS.itemStack()
                .canEquip((item, context) => {
                    let entity = context.entity()
                    return !hasCurio(entity, item)
                })
        )
        .maxStackSize(1)
        .rarity("rare")
        .tag("curios:head")
        .displayName("启示之冠").texture("advanced_creation:item/inspiration_crown")
        
     event.create("advanced_creation:lightning_tofu", "irons_spells_js:magic_sword")
        	.addAdditionalAttribute("irons_spellbooks:lightning_spell_power", "lightning_tofu", 0.3, "multiply_total")
        	.addAdditionalAttribute("forge:entity_reach", "lightning_tofu", 1, "addition")
        	.attackDamageBaseline(79)
        	.speedBaseline(0)
        	.addDefaultSpell("irons_spellbooks:shockwave", 16)
        	.displayName("闪电豆腐")
          
         
        
}
)
StartupEvents.registry('mob_effect', event => {
    event.create('advanced_creation:fragile') 
        .color(0x000000)
        .harmful()
        .modifyAttribute('l2damagetracker:damage_reduction', 
            'befed32b-d5bf-40dd-9224-3a9d59421b4b',
            0.25, 
            "multiply_total" 
        )
        .displayName("易碎")
})


